// ==UserScript==
// @name         YouTube 動画上だけスキップ＆速度ボタン (再生終了対応版)
// @namespace    http://tampermonkey.net/
// @version      18.2
// @description  YouTubeで動画上だけマウス動かしたらボタン表示。終了後は非表示、再生時に復活！
// @author       ChatGPT
// @match        https://www.youtube.com/*
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    let buttonContainer = null;
    let hideTimeout = null;
    let isMouseOverButton = false;
    let isMouseOverPlayer = false;
    let playerArea = null;
    let lastUrl = location.href;

    function isVideoPlaying() {
        const video = document.querySelector('video');
        return video && !video.paused && !video.ended && video.readyState > 2;
    }

    function createButtons() {
        // 古いボタン削除
        const existing = document.querySelector('.skip-buttons-container');
        if (existing) existing.remove();

        if (!location.pathname.startsWith('/watch')) return;

        playerArea = document.querySelector('.html5-video-player');
        if (!playerArea) return;

        buttonContainer = document.createElement('div');
        buttonContainer.classList.add('skip-buttons-container');
        buttonContainer.style.position = 'absolute';
        buttonContainer.style.top = '50%';
        buttonContainer.style.left = '20px';
        buttonContainer.style.transform = 'translateY(-50%)';
        buttonContainer.style.display = 'flex';
        buttonContainer.style.flexDirection = 'column';
        buttonContainer.style.alignItems = 'flex-start';
        buttonContainer.style.gap = '15px';
        buttonContainer.style.zIndex = '3000';
        buttonContainer.style.pointerEvents = 'auto';
        buttonContainer.style.opacity = '0';
        buttonContainer.style.transition = 'opacity 0.3s ease';
        buttonContainer.style.backgroundColor = 'rgba(0, 0, 0, 0.4)';
        buttonContainer.style.padding = '12px';
        buttonContainer.style.borderRadius = '10px';

        const skipGroup = document.createElement('div');
        skipGroup.style.display = 'flex';
        skipGroup.style.flexDirection = 'column';
        skipGroup.style.gap = '8px';

        const times = [1, 2, 10, 30];
        times.forEach(seconds => {
            const row = document.createElement('div');
            row.style.display = 'flex';
            row.style.gap = '8px';
            row.appendChild(createButton(`戻す ${seconds}秒`, () => skip(-seconds)));
            row.appendChild(createButton(`進める ${seconds}秒`, () => skip(seconds)));
            skipGroup.appendChild(row);
        });

        const speedGroup = document.createElement('div');
        speedGroup.style.display = 'flex';
        speedGroup.style.flexWrap = 'wrap';
        speedGroup.style.gap = '8px';
        speedGroup.style.marginTop = '12px';

        const speeds = [
            { label: '0.25倍', value: 0.25 },
            { label: '0.5倍', value: 0.5 },
            { label: '0.75倍', value: 0.75 },
            { label: '通常', value: 1 },
            { label: '1.25倍', value: 1.25 },
            { label: '1.5倍', value: 1.5 },
            { label: '2倍', value: 2 }
        ];

        speeds.forEach(speed => {
            speedGroup.appendChild(createButton(speed.label, () => setPlaybackRate(speed.value)));
        });

        buttonContainer.appendChild(skipGroup);
        buttonContainer.appendChild(speedGroup);

        playerArea.style.position = 'relative';
        playerArea.appendChild(buttonContainer);

        playerArea.addEventListener('mousemove', handleMouseMove);
        buttonContainer.addEventListener('mouseenter', () => {
            isMouseOverButton = true;
            if (isVideoPlaying()) showButtons();
        });
        buttonContainer.addEventListener('mouseleave', () => {
            isMouseOverButton = false;
            delayedHideButtons();
        });

        // 動画終了時に非表示、再生時に復活
        const video = document.querySelector('video');
        if (video) {
            video.addEventListener('ended', () => hideButtons());
            video.addEventListener('play', () => {
                if (isMouseOverPlayer || isMouseOverButton) showButtons();
            });
        }
    }

    function createButton(label, action) {
        const button = document.createElement('button');
        button.textContent = label;
        button.style.padding = '10px 14px';
        button.style.fontSize = '18px';
        button.style.backgroundColor = 'rgba(34, 34, 34, 0.6)';
        button.style.color = '#fff';
        button.style.border = '1px solid rgba(255, 255, 255, 0.3)';
        button.style.borderRadius = '8px';
        button.style.cursor = 'pointer';
        button.addEventListener('click', action);
        return button;
    }

    function handleMouseMove() {
        isMouseOverPlayer = true;
        if (isVideoPlaying()) {
            showButtons();
            delayedHideButtons();
        } else {
            hideButtons();
        }
    }

    function skip(seconds) {
        const video = document.querySelector('video');
        if (video) video.currentTime += seconds;
    }

    function setPlaybackRate(rate) {
        const video = document.querySelector('video');
        if (video) video.playbackRate = rate;
    }

    function showButtons() {
        if (buttonContainer) buttonContainer.style.opacity = '1';
    }

    function hideButtons() {
        if (buttonContainer) buttonContainer.style.opacity = '0';
    }

    function delayedHideButtons() {
        clearTimeout(hideTimeout);
        hideTimeout = setTimeout(() => {
            if (!isMouseOverButton && !isMouseOverPlayer) hideButtons();
        }, 1000);
    }

    // URL変更監視（動画切替対応）
    const observer = new MutationObserver(() => {
        if (location.href !== lastUrl) {
            lastUrl = location.href;
            setTimeout(createButtons, 500);
        }
    });
    observer.observe(document.body, { childList: true, subtree: true });

    window.addEventListener('load', () => setTimeout(createButtons, 500));

})();
